// (C)1997 Christian Janoff
// PKSTRING.CC

#include <iostream.h>
#include <string.h>
#include "pkstring.h"

ostream& operator<< (ostream& o, const pkstring& s)
{
    return o << s.content;
}

pkstring::pkstring(void)
{
  content=NULL;
}

pkstring::pkstring(char *str)
{
  content = new char[strlen(str)+1];
  strcpy(content,str);
}

pkstring::pkstring(pkstring const &other)
{
  content=new char[strlen(other.content)+1];
  strcpy(content,other.content);
}

pkstring::~pkstring(void)
{
    delete [] content;
}

char *pkstring::string(void)
{
  return content;
}

int pkstring::has_suffix(char *suffix)
{
  int i, j, len, suffix_len;

  if (suffix && content)
    {
      suffix_len=strlen(suffix);
	     len=strlen(content);
      if (suffix_len>len) return 0;
      for(i=suffix_len-1,j=len-1;i>=0;i--,j--)
        if(suffix[i]!=content[j]) return 0;
      return 1;
    }
  else return 0;
}

int pkstring::has_prefix(char *prefix)
{
  int i, len, prefix_len;

  if (prefix && content)
    {
      prefix_len = strlen(prefix);
	     len = strlen(content);
      if (prefix_len>len) return 0;
      for(i=0;i<prefix_len;i++)
	if (prefix[i]!=content[i]) return 0;
      return 1;
    }
  else return 0;
}

int pkstring::is(char *other)
{
  if (other && content)
    return (this->has_suffix(other) && strlen(other)==strlen(content));
  else return 0;
}

int pkstring::remove_suffix(char *suffix)
{
  remove_prefix_or_suffix(suffix, 1); // 0 = prefix , 1 = suffix
}

int pkstring::remove_prefix(char *prefix)
{
  remove_prefix_or_suffix(prefix, 0); // 0 = prefix , 1 = suffix
}

int pkstring::remove_prefix_or_suffix(char *prefix_or_suffix, int suffix)
{
  int len, prefix_or_suffix_len, count;
  char *new_content, *from;

  if (suffix ? this->has_suffix(prefix_or_suffix) : this->has_prefix(prefix_or_suffix) )
    {
      prefix_or_suffix_len = strlen(prefix_or_suffix);
	               len = strlen(content);
                     count = len-prefix_or_suffix_len;
      if (count>0)
	{
	  new_content = new char[len-prefix_or_suffix_len+1];
	  if (!suffix)
	    from = content+prefix_or_suffix_len;
	  else
	    from = content;
	  strncpy(new_content,from,count);
	  new_content[count] = 0;
	  delete [] content;
	  content = new_content;
	}
      else
	{
	  delete [] content;
	  content = NULL;
	}
    }
}

unsigned int pkstring::len(void)
{
  if (content)
    return strlen(content);
  else return 0;
}

void pkstring::remove_first(unsigned int firstchars)
{
  unsigned int i, len;
  char* new_content;

  if (content)
    {
       len = strlen(content);
       if (firstchars <= len)
         {
           if (len-firstchars > 0)
             {
               new_content = new char[len-firstchars+1];
               for(i=0;i<=len-firstchars;i++)
                 new_content[i]=content[i+firstchars];
             }
           else new_content=NULL;
           delete [] content;
           content=new_content;
         }
    }
}

pkstring& pkstring::operator=(pkstring const &other)
{
  if (this!=&other)                     // (string1=string1)
    {
      unsigned int length=0;

      delete [] content;

      if (other.content)
	{
	  length=strlen(other.content);
	  content = new char[length+1];
	  strcpy(content,other.content);
	}
      else content=NULL;
    }
  return (*this);
}

pkstring& pkstring::operator=(char *other)
{
  unsigned int length;

  if (other)
    {
      length=strlen(other);
      delete [] content;
      content = new char[length+1];
      strcpy(content,other);
    }
  else
    {
      delete [] content;
      content=NULL;
    }
  return (*this);
}

pkstring& pkstring::operator+ (pkstring &other)
{
  unsigned int new_length,
               length;
          char *new_string;

  if (other.content)
    {
      if (content)
	length=strlen(content);
      else length=0;

      new_length=strlen(other.content)+length;

      new_string=new char[new_length+1];

      if (content)
	strcpy(new_string,content);
      strcpy(new_string+length,other.content);
      delete [] content;
      content=new_string;
    }
  return (*this);
}

pkstring& pkstring::operator+ (char *other)
{
  unsigned int new_length,
               length;
          char *new_string;

  if (other)
    {
      if (content)
	length=strlen(content);
      else length=0;
      
      new_length=strlen(other)+length;
      new_string=new char[new_length+1];

      if (content)
	strcpy(new_string,content);

      strcpy(new_string+length,other);
      delete [] content;

      content=new_string;
    }
  return (*this);
}

pkstring& pkstring::operator+(char c)
{
  unsigned int length;
          char *new_string;

  if (content)
    length=strlen(content);
  else length=0;

  new_string=new char[length+2];
  if (content)
    strcpy(new_string,content);
  new_string[length]  = c;
  new_string[length+1]= 0;
  delete [] content;
  content=new_string;

  return (*this);
}

char& pkstring::operator[](unsigned int index)
{
  if (content)
    {
      if (index<0 || index>strlen(content)-1)
	{
	  cerr << "*** PKSTRING: invalid index " << index
	       << " (should be 0.."         << strlen(content)-1 << " )." << endl
	       << "*** Exiting." << endl;
	  exit(0);
	}
    }
  else 
    {
          cerr << "*** PKSTRING: invalid string has no index." << endl
               << "*** Exiting." << endl;
          exit(0);
    }
  return content[index];
}

void pkstring::conv2basename(void)
{
  unsigned int i,j,from,to;
  char * content2;

  if (content) // nur ausfuehren, wenn String vorhanden
    {
      for(i=strlen(content);i>=0 && content[i-1]=='/';i--);
      to=i;

      for(;i>0 && content[i-1]!='/';i--);
      from=i;

      if (to-1!=from)
	{
	  content2 = new char [to-from+1];
	  for(j=0,i=from;i<to;i++,j++)
	    content2[j]=content[i];
	  content2[j]=0;
	  delete [] content;
	  content=content2;
	}
      else
	{
	  delete [] content;
	  content=NULL;
	}
    }
}

void pkstring::conv2pathname(void)
{
  unsigned int i,to;
  char * content2;

  if (content)
    {
      for(i=strlen(content);i>=0 && content[i-1]=='/';i--);
      for(;i>0 && content[i-1]!='/';i--);
      for(;i>0 && content[i-1]=='/';i--);
      to=i;
      
      if (i!=0)
	{
	  content2 = new char [i+1];
	  for(i=0;i<to;i++)
	    content2[i]=content[i];
	  content2[i]=0;
	  delete [] content;
	  content=content2;
	}
      else
	{
	  delete [] content;
	  content=NULL;
	}
    }
}
